package cmpe160.s20151.project1.platform;

import java.awt.Color;
import java.awt.EventQueue;

import javax.swing.JFrame;
import javax.swing.JPanel;

/**
 * The main application window
 * @author cantunca
 * @version 1.0
 */
public class GUI {

	private JFrame frame;
	private Canvas canvas;

	/**
	 * No argument constructor.
	 * Creates and shows the application window (frame).
	 */
	public GUI() {
		initialize();
		start();
	}

	/**
	 * Initialize the contents of the frame.
	 */
	private void initialize() {
		frame = new JFrame();
		frame.setResizable(false);
		frame.setBounds(100, 100, 500, 520);
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}
	
	/**
	 * Run and show the frame.
	 */
	private void start() {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}
	
	/**
	 * Adds a canvas to the application window.
	 * The canvas is immediately shown and made functional.
	 * @param canvas
	 */
	public void addCanvas(Canvas canvas) {
		this.canvas = canvas;
		canvas.setBackground(Color.WHITE);
		frame.getContentPane().add(canvas);
		frame.pack();
	}
	
	/**
	 * Returns the drawing canvas previously added to the application window.
	 * @return The canvas to be drawn to.
	 */
	public JPanel getCanvas() {
		return canvas;
	}

}
