% Written by Cem Say

:-dynamic agentLoc/3, alreadyActed/1, fitness/2, nextG/1, num/1, bestOf/3.
:-set_prolog_flag(toplevel_print_options,[quoted(true), portray(true), max_depth(40)]).
:-[agents].

%:-dynamic myloc/2.




% The rules that an agent must obey to perform wall following behaviour

findact(a(o,A),B):-retract(myloc(X,Y)),!,zz(X,Y,A,B),update(X,Y,B).
findact(a(o,A),A):-!,update(0,0,A).
findact(A,A).

zz(0,0,_,nil):-!.
zz(_,_,A,A).

update(_,_,nil):-!,assert(myloc(0,0)).
update(X,Y,north(_)):-NY is Y+1, assert(myloc(X,NY)),!.
update(X,Y,south(_)):-NY is Y-1, assert(myloc(X,NY)),!.
update(X,Y,east(_)):-NX is X+1, assert(myloc(NX,Y)),!.
update(X,Y,west(_)):-NX is X-1, assert(myloc(NX,Y)),!.








%== GRID DEFINITION ==




%These correspond to the original figure from Chapter 2

gridSize(14,11). %max x value, max y value

obstacle([3,5],[4,6]).
obstacle([3,7],[8,7]).
obstacle([7,5],[8,6]).
obstacle([6,1],[8,2]).
obstacle([12,1],[14,4]).
obstacle([12,8],[14,11]).


%== PRINTING THE GRID ==

gridPrint:-
	nl,
	gridSize(MaxCol,MaxRow),	
	gridPrint(1,MaxRow,MaxCol).

gridPrint(MaxRow,MaxRow,MaxCol):-
	!,
	rowPrint(1,MaxRow,MaxRow,MaxCol).
gridPrint(ThisRow,MaxRow,MaxCol):-
	rowPrint(1,ThisRow,MaxRow,MaxCol),
	NextRow is ThisRow + 1,
	gridPrint(NextRow,MaxRow,MaxCol).

rowPrint(MaxCol,ThisRow,MaxRow,MaxCol):-
	!,
	printVal(ThisRow,MaxRow,MaxCol),
	nl.
rowPrint(ThisCol,ThisRow,MaxRow,MaxCol):-
	printVal(ThisRow,MaxRow,ThisCol),
	NextCol is ThisCol + 1,
	rowPrint(NextCol,ThisRow,MaxRow,MaxCol).

printVal(Row,MaxRow,X):-  
	Y is MaxRow - Row + 1,
	gridVal(X,Y,V),
	name(V,[C|_]),
	name(NV,[C]),
	write(NV).



%== THE GRID ==

inObstacle(X,Y):-
	obstacle([LX,LY],[HX,HY]),
	X>=LX, X=<HX, Y>=LY, Y=< HY.

notfree(V):-not(V='.').

gridVal(0,_,'O'):-!.
gridVal(_,0,'O'):-!.
gridVal(X,_,'O'):-
	gridSize(MR,_),
	X is MR + 1,
	!.
gridVal(_,Y,'O'):-
	gridSize(_,MC),
	Y is MC + 1,
	!.
gridVal(X,Y,'O'):-
	inObstacle(X,Y),
	!.
gridVal(X,Y,Agent):-
	agentLoc(Agent,X,Y),
	!.
gridVal(_,_,'.').

%== ACTIONS SUBMITTED BY AGENTS ==

run(Action):-
	Action =.. [_,Agent],
	alreadyActed(Agent),!.
run(north(A)):-
	agentLoc(A,X,Y),
	NY is Y+1,
        gridVal(X,NY,V),
       	V='.',!,
	retract(agentLoc(A,X,Y)),
	assert(agentLoc(A,X,NY)),
	assert(alreadyActed(A)).
run(east(A)):-
	agentLoc(A,X,Y),
	NX is X+1,
        gridVal(NX,Y,V),
       	V='.',!,
	retract(agentLoc(A,X,Y)),
	assert(agentLoc(A,NX,Y)),
	assert(alreadyActed(A)).
run(south(A)):-
	agentLoc(A,X,Y),
	NY is Y-1,
        gridVal(X,NY,V),
       	V='.',!,
	retract(agentLoc(A,X,Y)),
	assert(agentLoc(A,X,NY)),
	assert(alreadyActed(A)).
run(west(A)):-
	agentLoc(A,X,Y),
	NX is X-1,
        gridVal(NX,Y,V),
       	V='.',!,
	retract(agentLoc(A,X,Y)),
	assert(agentLoc(A,NX,Y)),
	assert(alreadyActed(A)).
run(_).


%== SENSORY INPUTS FOR AGENT A ==

s1(A):-agentLoc(A,X,Y),	
       NX is X-1,
       NY is Y+1,
       gridVal(NX,NY,V),!,notfree(V).
s2(A):-agentLoc(A,X,Y),
       NY is Y+1,
       gridVal(X,NY,V),!,notfree(V).
s3(A):-agentLoc(A,X,Y),
       NX is X+1,
       NY is Y+1,
       gridVal(NX,NY,V),!,notfree(V).
s4(A):-agentLoc(A,X,Y),
       NX is X+1,
       gridVal(NX,Y,V),!,notfree(V).
s5(A):-agentLoc(A,X,Y),
       NX is X+1,
       NY is Y-1,
       gridVal(NX,NY,V),!,notfree(V).
s6(A):-agentLoc(A,X,Y),
       NY is Y-1,
       gridVal(X,NY,V),!,notfree(V).
s7(A):-agentLoc(A,X,Y),
       NX is X-1,
       NY is Y-1,
       gridVal(NX,NY,V),!,notfree(V).
s8(A):-agentLoc(A,X,Y),
       NX is X-1,
       gridVal(NX,Y,V),!,notfree(V).




%== STARTUP AND EXECUTION	
	
readAgents(As,FinalAs):-
       nl,write('Name of agent? (A number.) (Terminate with .)(Enter 0 to end agent entry)'),
       read(A),
       not(A=0),!,
       nl,write('Enter initial x coordinate. (Terminate with .)'),
       read(X),
       nl,write('Enter initial y coordinate. (Terminate with .)'),
       read(Y),
       gridVal(X,Y,V),
       V='.',
%       name(A,[C]),
       assert(agentLoc(A,X,Y)),
       readAgents([A|As],FinalAs).
readAgents(As,As).


world:-gridPrint,
       readAgents([],As),
       gridPrint,
       write('For next grid, press enter. To exit, press e'),nl,
       get_single_char(C), 
       not(C=101),            %e
       life(As,1).	%initial list of agents (they have unique single-char names)
world/*:-retractall(agentLoc(_,_,_))*/. 
%Open the comment on the above line if you wish to remove the agents from the board at the end.
       
life([A1|Arest],Step):-
	write('In step '),write(Step),write(':'),
	timeStep([A1|Arest]), 
      	gridPrint,	
      	get_single_char(C),
      	not(C=101),            %e
	append(Arest,[A1],NewAs),
	NS is Step + 1,
	retractall(alreadyActed(_)),
      	life(NewAs,NS).


timeStep([]).
timeStep([A|As]):-
	agentAct(A),!,
write(acted(A)),
	timeStep(As).

